'use strict';

function EndRoundModalCtrl($scope, $rootScope, $http){

    $scope.disabled = true;

    angular.element('#modal-end-round').modal({
        backdrop: 'static'
        ,keyboard: false
        ,show: false
    });



    $scope.openModal = function(){
        angular.element('#modal-end-round').modal('show');
    }

    $scope.closeModal = function(){
        angular.element('#modal-end-round').modal('hide');
        window.location = appDev + '/admin'
    }

    $scope.$on('ModalEndRound:show', function(event, group){
        $scope.openModal();
        $http.get(appDev + '/admin/api/end_round/'+group.id)
            .success(function(data){
                if(data.success)
                {
                    $scope.disabled = false;
                }
                else
                {
                    angular.element('#modal-end-round').modal('hide');
                    $rootScope.$broadcast('Message:error', data.error);
                }
            })
        ;
    });

}

EndRoundModalCtrl.$inject = ['$scope', '$rootScope', '$http'];